(function(_window, _log, _TrackingJavascriptInterface) {
    'use strict';

    /*
     * Tracking Singleton
     */
    var Tracking = (function() {
        // Private vars
        var TAG = 'Tracking',
            instance;


        function getInstance() {
            // Public vars
            return {
                /**
                 * Log Event
                 *
                 * IPC call to log tracking event inside Java runtime.
                 *
                 * @param {string} eventName
                 * @param {boolean} fromUserInteraction
                 * @param {?object} trackingParams HashMap including all tracking parameters
                 */
                logEvent: function(eventName, fromUserInteraction, trackingParams) {
                    var jsonStr;

                    if (_log.shouldLog(_log.INFO)) {
                        _log.i('[' + TAG + ']' + ' Logging event: ' + eventName + ' with user inteteraction: ' + fromUserInteraction);
                    }

                    try {
                        jsonStr = trackingParams ? JSON.stringify(trackingParams) : '';
                    } catch(err) {
                        _log.e(err);
                    }

                    _TrackingJavascriptInterface.logEvent(eventName, fromUserInteraction, jsonStr);
                }
            };
        }

        return {
            getInstance: function() {
                instance = instance || getInstance();
                return instance;
            }
        };
    })();

    window.Tracking = Tracking;
})(window, window.log, window.TrackingJavascriptInterface);
